<?php
class ControllerExtensionAbandonedCartAbandonedCart extends Controller {

	private $error = array();

	public function index()
	{
		$this->load->language('abandoned_cart/abandoned_cart');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/abandoned_cart/abandoned_cart');

		$this->getCartDetails();
		
	}

	public function getCartDetails()
	{

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'id.title';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/abandoned_cart/abandoned_cart', 'user_token=' . $this->session->data['user_token'] . $url, true)
			);

		$data['set_value'] = $this->url->link('extension/abandoned_cart/abandoned_cart/setCron', 'user_token=' . $this->session->data['user_token'], true);

		$data['email'] = $this->url->link('extension/abandoned_cart/abandoned_cart/email', 'user_token=' . $this->session->data['user_token'], true);

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		if (isset($this->request->post['day'])) {				
		$data['day'] = (array)$this->request->post['day'];			
		} else {				
		$data['day'] = array();			}
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['products'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
			);
		$total_info = $this->model_extension_abandoned_cart_abandoned_cart->getTotalInformations();
		$results = $this->model_extension_abandoned_cart_abandoned_cart->getDetails($filter_data);
		
		$this->load->model('tool/image');

		foreach ($results as $result) {

			if (is_file(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.png', 40, 40);
			}

			if (isset($this->request->post['selected'])) {
				$data['selected'] = (array)$this->request->post['selected'];
			} else {
				$data['selected'] = array();
			}			
			$data['products'][] = array(

				'cart_id' 		=> $result['cart_id'],				
				'customer_details' 		=> $result['customer_details'],				
				'product_id'   			=> $result['product_id'],
				'image'    				=> $image,
				'product_name'    		=> $result['product_name'],				
				'name'    				=> $result['product_name'],				
				'quantity'				=> $result['quantity'],
				'unit_price'    		=> $result['price'],
				'sub_total'    			=> $result['sub_total'],				
				//'date_added'			=> $result['date_added'],				
				'href'     		   => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'], true)

				);
		}
	
		$cron_values = array();
		$cron_values = $this->model_extension_abandoned_cart_abandoned_cart->getCronValue();
		
		$data['delete'] = $this->url->link('extension/abandoned_cart/abandoned_cart/delete', 'user_token=' . $this->session->data['user_token'], true);
		
		$data['sendmail'] = $this->url->link('extension/abandoned_cart/abandoned_cart/sendmail', 'user_token=' . $this->session->data['user_token'], true);
		
		$data['email_template'] = $this->model_extension_abandoned_cart_abandoned_cart->emailTemplate();
		
		$arr = array();

		foreach ($cron_values as $key => $value) {

			$arr[$value['days']] = $value['time'];
		}

		$data['cron_values'] = $arr;
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_reminder_mail'] = $this->language->get('text_reminder_mail');
		$data['text_email'] = $this->language->get('text_email');
		$data['text_email_template'] = $this->language->get('text_email_template');
		$data['text_cron'] = $this->language->get('text_cron');
		$data['text_days'] = $this->language->get('text_days');
		$data['text_time'] = $this->language->get('text_time');
		$data['text_monday'] = $this->language->get('text_monday');
		$data['text_tuesday'] = $this->language->get('text_tuesday');
		$data['text_wednesday'] = $this->language->get('text_wednesday');
		$data['text_thursday'] = $this->language->get('text_thursday');
		$data['text_friday'] = $this->language->get('text_friday');
		$data['text_saturday'] = $this->language->get('text_saturday');
		$data['text_sunday'] = $this->language->get('text_sunday');
		$data['text_subject'] = $this->language->get('text_subject');
		$data['text_email_body'] = $this->language->get('text_email_body');
		$data['text_hints'] = $this->language->get('text_hints');
		$data['text_firstname'] = $this->language->get('text_firstname');
		$data['text_lastname'] = $this->language->get('text_lastname');
		$data['text_product'] = $this->language->get('text_product');
		$data['text_customer_name'] = $this->language->get('text_customer_name');		
		$data['text_product_link'] = $this->language->get('text_product_link');
		$data['text_success'] = $this->language->get('text_success');
		$data['notify_customer'] = $this->language->get('notify_customer');
		$data['notify_customer_button_text'] = $this->language->get('notify_customer_button_text');
		$data['text_success_sendmail'] = $this->language->get('text_success_sendmail');
		

		$data['button_submit'] = $this->language->get('button_submit');
		$data['button_send'] = $this->language->get('button_send');
		
		$data['column_product_id'] = $this->language->get('column_product_id');
		$data['column_product_image'] = $this->language->get('column_product_image');
		$data['column_product_name'] = $this->language->get('column_product_name');
		$data['column_customer_details'] = $this->language->get('column_customer_details');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_unit_price'] = $this->language->get('column_unit_price');
		$data['column_sub_total'] = $this->language->get('column_sub_total');
		$data['column_date_created'] = $this->language->get('column_date_created');
		$data['column_reminder_mail'] = $this->language->get('column_reminder_mail');

		$pagination = new Pagination();
		$pagination->total = $total_info;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('extension/abandoned_cart/abandoned_cart', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);
		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_info) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_info - $this->config->get('config_limit_admin'))) ? $total_info : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_info, ceil($total_info / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/abandoned_cart/abandoned_cart', $data));

	}

public function setCron(){
	
	$this->load->language('abandoned_cart/abandoned_cart');

	$this->document->setTitle($this->language->get('heading_title'));

	$this->load->model('extension/abandoned_cart/abandoned_cart');
	if(($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

		$days = $this->request->post['day'];
		$times = $this->request->post['time'];
		$this->model_extension_abandoned_cart_abandoned_cart->setCron($days, $times);
		$this->session->data['success'] = $this->language->get('text_success'); 	
	}
	$this->getCartDetails();
}

public function sendmail(){
        $this->load->language('cart/abandoned_cart');

		$this->load->language('abandoned_cart/abandoned_cart');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('extension/abandoned_cart/abandoned_cart');
		
	if (isset($this->request->post['selected'])) {
		
		$this->load->model('extension/abandoned_cart/abandoned_cart');
		$email_template = $this->model_extension_abandoned_cart_abandoned_cart->emailTemplate();
		
			$custarray = array();
			foreach($this->request->post['selected'] as $cart_id ){
				$customers = $this->model_extension_abandoned_cart_abandoned_cart->getcustomersfromCart($cart_id);
				$this->session->data['success'] = $this->language->get('text_success_sendmail');
				if(!empty($customers)) {
					foreach($customers as $customer) {
						$custarray[] = $customer['customer_id'];
					}
				}
			}
			if(!empty($custarray)) {
				$custarray = array_unique($custarray);
			foreach ($custarray as $customer_id){
				$value = $this->model_extension_abandoned_cart_abandoned_cart->getcartDetails($customer_id);
				$products = $this->model_extension_abandoned_cart_abandoned_cart->cartDetails($customer_id);
				$name = $value['customer_name'];
				$link ='';
				$i=1;

			foreach($products as $product) {

				$link .= $i.'. <a href="'.$this->config->get('config_url').'index.php?route=product/product&&product_id='. $product['product_id'].'">'.$product['product_name'].'</a><br>';
				$i++;
			} 
				$email = $value['email'];
				$subject = $email_template['subject'];
				$body = $email_template['body'];		
			
				$var = array('_name', '_links');
				$val = array($name, $link);
				$email_body = str_replace($var, $val, $body);
				
				$body1 = html_entity_decode($email_body, ENT_QUOTES, 'UTF-8');
				
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
				$mail->smtp_username = $this->config->get('config_mail_smtp_username');
				$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), 	ENT_QUOTES, 'UTF-8');
				$mail->smtp_port = $this->config->get('config_mail_smtp_port');
				$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

				$mail->setTo($value['email']);
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
		
				$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
				$mail->setHtml($body1);
				
				$mail->send();
		    }
				
	    } 
		    $url = "";
			$this->response->redirect($this->url->link('extension/abandoned_cart/abandoned_cart', 'user_token=' . $this->session->data['user_token'] . $url, true));
	}
	 $this->getCartDetails();
}
	public function delete(){
		//echo "delete"; die;
			$this->load->language('abandoned_cart/abandoned_cart');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->load->model('extension/abandoned_cart/abandoned_cart');
		if (isset($this->request->post['selected'])) {
			$this->load->model('extension/abandoned_cart/abandoned_cart');
			$email_template = $this->model_extension_abandoned_cart_abandoned_cart->emailTemplate();
			  foreach ($this->request->post['selected'] as $cart_id) {
			    $this->model_extension_abandoned_cart_abandoned_cart->deleteItems($cart_id);
				$this->session->data['success'] = $this->language->get('text_success'); 
			  }
			  $url = "";
			$this->response->redirect($this->url->link('extension/abandoned_cart/abandoned_cart', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}
		 $this->getCartDetails();
	}
	
	public function email(){
		$this->load->language('abandoned_cart/abandoned_cart');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/abandoned_cart/abandoned_cart');

		if(isset($this->request->post['subject']) && isset($this->request->post['body'])) {
			
			$subject = $this->request->post['subject'];
			$body = $this->request->post['body'];
			$this->model_extension_abandoned_cart_abandoned_cart->email($subject, $body);
		}
		
		$this->getCartDetails();
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/abandoned_cart/abandoned_cart')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}	
		if (!isset($this->request->post['day'])) {
				$this->error['warning'] = $this->language->get('error_warning');
			}

			return !$this->error;
	}

}



?>