<?php
class ControllerExtensionCronCron extends Controller {

	public function index()
	{
		$this->load->language('abandoned_cart/abandoned_cart');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/cron/cron');

	}

	public function cronValue()
	{
		
		$this->load->model('extension/cron/cron');
		$cron_values = $this->model_extension_cron_cron->cronValue();
		$email_template = $this->model_extension_cron_cron->emailTemplate();
		$cart_customers = $this->model_extension_cron_cron->cartCustomers();
		
		
		if(!empty($cart_customers)){
			foreach($cart_customers as $cart_customer){
				$cart_details[] = array(
					'email' => $cart_customer['email'],
					'customer_name' => $cart_customer['customer_name'],
					'products' => $this->model_extension_cron_cron->cartDetails($cart_customer['customer_id'])
				);
			}
		}

		foreach ($cron_values as $key => $value)	
		{ 	
			
			$time1 = strtotime($value['time']);
			$time2 = strtotime(date('H:i'));
			$timediff = abs($time1 - $time2)/60;	
			
			 if($value['days'] == strtolower(date('D')) && $timediff < 10)
			{
	
				foreach ($cart_details as $key => $value)
				{					
					$name = $value['customer_name'];
					$link ='';
					$i=1;
					foreach($value['products'] as $product) {
					
						$link .= $i.'. <a href="'.$this->config->get('config_url').'index.php?route=product/product&&product_id='. $product['product_id'].'">'.$product['product_name'].'</a><br>';
						$i++;
					}
					$email = $value['email'];
					$subject = $email_template['subject'];
					$body = $email_template['body'];		
				
					$var = array('_name', '_links');
					$val = array($name, $link);
					$email_body = str_replace($var, $val, $body);
					
					$body1 =html_entity_decode($email_body, ENT_QUOTES, 'UTF-8');
					
					$mail = new Mail();
					$mail->protocol = $this->config->get('config_mail_protocol');
					$mail->parameter = $this->config->get('config_mail_parameter');
					$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
					$mail->smtp_username = $this->config->get('config_mail_smtp_username');
					$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), 	ENT_QUOTES, 'UTF-8');
					$mail->smtp_port = $this->config->get('config_mail_smtp_port');
					$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

					$mail->setTo($value['email']);
					$mail->setFrom($this->config->get('config_email'));
					$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
					
					$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
					$mail->setHtml($body1);
					
					$mail->send();
					
			 }
		}
	}
}

}
?>